/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components.input;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.input.AbstractTextInput;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.constraints.animation.AnimatingConstraints;
import gg.essential.elementa.constraints.animation.Animations;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.effects.ScissorEffect;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.events.UIScrollEvent;
import gg.essential.elementa.font.FontProvider;
import gg.essential.elementa.utils.TextKt;
import gg.essential.universal.UDesktop;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010 \n\u0002\b\u000e\b&\u0018\u0000 \u00b5\u00012\u00020\u0001:\u0016\u00b4\u0001\u00b5\u0001\u00b6\u0001\u00b7\u0001\u00b8\u0001\u00b9\u0001\u00ba\u0001\u00bb\u0001\u00bc\u0001\u00bd\u0001\u00be\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\u001c\u0010u\u001a\u00020\u00132\u0006\u0010v\u001a\u00020\u00032\n\u0010w\u001a\u00060\u001fR\u00020\u0000H\u0004J\b\u0010x\u001a\u00020\u0013H\u0014J\b\u0010y\u001a\u00020\u0013H\u0016J\u001b\u0010z\u001a\u0004\u0018\u00010{2\n\u0010|\u001a\u00060\u001fR\u00020\u0000H\u0014\u00a2\u0006\u0002\u0010}J\u001b\u0010~\u001a\u0004\u0018\u00010{2\n\u0010|\u001a\u00060\u001fR\u00020\u0000H\u0014\u00a2\u0006\u0002\u0010}J\u0010\u0010\u007f\u001a\u00020\u00132\u0006\u0010v\u001a\u00020\u0003H\u0004J\u0016\u0010\u0080\u0001\u001a\u00020\u00132\u000b\u0010\u0081\u0001\u001a\u00060UR\u00020\u0000H\u0014J,\u0010\u0082\u0001\u001a\u00020\u00132\u000b\u0010\u0083\u0001\u001a\u00060\u001fR\u00020\u00002\u000b\u0010\u0084\u0001\u001a\u00060\u001fR\u00020\u00002\u0007\u0010\u0085\u0001\u001a\u00020\u0005H\u0004J\t\u0010\u0086\u0001\u001a\u00020\u0013H\u0014J\t\u0010\u0087\u0001\u001a\u00020\u0013H\u0014J\u0013\u0010\u0088\u0001\u001a\u00020\u00132\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J6\u0010\u008b\u0001\u001a\u00020\u00132\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u0010\u0012\u001a\u00020\u00032\u0007\u0010\u008c\u0001\u001a\u0002002\u0007\u0010\u008d\u0001\u001a\u0002002\u0007\u0010\u008e\u0001\u001a\u000208H\u0014J,\u0010\u008b\u0001\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00032\u0007\u0010\u008c\u0001\u001a\u0002002\u0007\u0010\u008d\u0001\u001a\u0002002\u0007\u0010\u008e\u0001\u001a\u000208H\u0015J6\u0010\u008f\u0001\u001a\u00020\u00132\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u0010\u0012\u001a\u00020\u00032\u0007\u0010\u008c\u0001\u001a\u0002002\u0007\u0010\u008d\u0001\u001a\u0002002\u0007\u0010\u008e\u0001\u001a\u000208H\u0004J-\u0010\u0090\u0001\u001a\u00020\u00132\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u0010\u0012\u001a\u00020\u00032\u0007\u0010\u008c\u0001\u001a\u0002002\u0007\u0010\u008e\u0001\u001a\u000208H\u0014J#\u0010\u0090\u0001\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00032\u0007\u0010\u008c\u0001\u001a\u0002002\u0007\u0010\u008e\u0001\u001a\u000208H\u0015J-\u0010\u0091\u0001\u001a\u00020\u00132\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u0010\u0012\u001a\u00020\u00032\u0007\u0010\u008c\u0001\u001a\u0002002\u0007\u0010\u008e\u0001\u001a\u000208H\u0004J#\u0010\u0092\u0001\u001a\u00060\u001fR\u00020\u00002\n\u0010|\u001a\u00060\u001fR\u00020\u00002\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0014J\u001d\u0010\u0095\u0001\u001a\u0016\u0012\b\u0012\u00060\u001fR\u00020\u0000\u0012\b\u0012\u00060\u001fR\u00020\u00000>H\u0014J\t\u0010\u0096\u0001\u001a\u00020\u0003H&J#\u0010\u0097\u0001\u001a\u00020\u00032\u000b\u0010\u0083\u0001\u001a\u00060\u001fR\u00020\u00002\u000b\u0010\u0084\u0001\u001a\u00060\u001fR\u00020\u0000H\u0014J\t\u0010\u0098\u0001\u001a\u00020\u0005H\u0014J\t\u0010\u0099\u0001\u001a\u00020\u0005H\u0014J\u0007\u0010\u009a\u0001\u001a\u00020\u0005J\u0012\u0010\u009b\u0001\u001a\u00020\u00052\u0007\u0010\u009c\u0001\u001a\u00020{H\u0014J+\u0010\u009d\u0001\u001a\u00020\u00002\"\u0010\u009e\u0001\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fJ\t\u0010\u009f\u0001\u001a\u00020\u0013H$J+\u0010\u00a0\u0001\u001a\u00020\u00002\"\u0010\u009e\u0001\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fJ\t\u0010\u00a1\u0001\u001a\u00020\u0013H\u0014J\t\u0010\u00a2\u0001\u001a\u00020\u0013H$J\u0012\u0010\u00a3\u0001\u001a\u00020\u00132\u0007\u0010\u00a4\u0001\u001a\u000208H\u0014J#\u0010\u00a5\u0001\u001a\u00020\u00132\u000b\u0010\u0083\u0001\u001a\u00060\u001fR\u00020\u00002\u000b\u0010\u0084\u0001\u001a\u00060\u001fR\u00020\u0000H\u0002J\u001f\u0010\u00a6\u0001\u001a\u00060\u001fR\u00020\u00002\u0007\u0010\u00a7\u0001\u001a\u0002002\u0007\u0010\u00a8\u0001\u001a\u000200H$J\u0015\u0010\u00a9\u0001\u001a\u00020\u00132\n\u0010|\u001a\u00060\u001fR\u00020\u0000H$J\t\u0010\u00aa\u0001\u001a\u00020\u0013H\u0014J\r\u0010\u00ab\u0001\u001a\u00060\u001fR\u00020\u0000H\u0014J\r\u0010\u00ac\u0001\u001a\u00060\u001fR\u00020\u0000H\u0014J\u000f\u0010\u001b\u001a\u00020\u00002\u0007\u0010\u009a\u0001\u001a\u00020\u0005J\u0016\u0010\u00ad\u0001\u001a\u00020\u00132\u000b\u0010\u00ae\u0001\u001a\u00060\u001fR\u00020\u0000H\u0002J\u000f\u0010\u00af\u0001\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0003J!\u0010\u00b0\u0001\u001a\t\u0012\u0004\u0012\u00020\u00030\u00b1\u00012\u0006\u0010\u0012\u001a\u00020\u00032\u0007\u0010\u00b2\u0001\u001a\u000200H\u0014J\u0018\u0010\u00b3\u0001\u001a\t\u0012\u0004\u0012\u00020\u00030\u00b1\u00012\u0006\u0010\u0012\u001a\u00020\u0003H$R5\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\t\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR,\u0010 \u001a\u00060\u001fR\u00020\u00002\n\u0010\u001e\u001a\u00060\u001fR\u00020\u0000@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\f\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001a\"\u0004\b.\u0010\u001cR\u001a\u0010/\u001a\u000200X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0014\u0010\n\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010&R\u0014\u0010\u000b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010&R\u001a\u00107\u001a\u000208X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R.\u0010=\u001a\u0016\u0012\b\u0012\u00060\u001fR\u00020\u0000\u0012\b\u0012\u00060\u001fR\u00020\u00000>X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR$\u0010I\u001a\u0002002\u0006\u0010\u001e\u001a\u000200@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u00102\"\u0004\bK\u00104R,\u0010L\u001a\u00060\u001fR\u00020\u00002\n\u0010\u001e\u001a\u00060\u001fR\u00020\u0000@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\"\"\u0004\bN\u0010$R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001e\u0010S\u001a\f\u0012\b\u0012\u00060UR\u00020\u00000TX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010&R\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010&R\u001a\u0010Z\u001a\u00020[X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010\u001a\"\u0004\ba\u0010\u001cR\u001a\u0010b\u001a\u000200X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u00102\"\u0004\bd\u00104R\u001e\u0010e\u001a\f\u0012\b\u0012\u00060gR\u00020\u00000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010iR\u001e\u0010j\u001a\f\u0012\b\u0012\u00060UR\u00020\u00000TX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010WR5\u0010l\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010\u0015\"\u0004\bn\u0010\u0017R\u001a\u0010o\u001a\u000200X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u00102\"\u0004\bq\u00104R\u001e\u0010r\u001a\f\u0012\b\u0012\u00060sR\u00020\u00000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010i\u00a8\u0006\u00bf\u0001"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput;", "Lgg/essential/elementa/UIComponent;", "placeholder", "", "shadow", "", "selectionBackgroundColor", "Ljava/awt/Color;", "selectionForegroundColor", "allowInactiveSelection", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "(Ljava/lang/String;ZLjava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "activateAction", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "text", "", "getActivateAction", "()Lkotlin/jvm/functions/Function1;", "setActivateAction", "(Lkotlin/jvm/functions/Function1;)V", "active", "getActive", "()Z", "setActive", "(Z)V", "getAllowInactiveSelection", "value", "Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;", "cursor", "getCursor", "()Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;", "setCursor", "(Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;)V", "getCursorColor", "()Ljava/awt/Color;", "cursorComponent", "getCursorComponent", "()Lgg/essential/elementa/UIComponent;", "setCursorComponent", "(Lgg/essential/elementa/UIComponent;)V", "cursorNeedsRefocus", "getCursorNeedsRefocus", "setCursorNeedsRefocus", "horizontalScrollingOffset", "", "getHorizontalScrollingOffset", "()F", "setHorizontalScrollingOffset", "(F)V", "getInactiveSelectionBackgroundColor", "getInactiveSelectionForegroundColor", "initiallySelectedLine", "", "getInitiallySelectedLine", "()I", "setInitiallySelectedLine", "(I)V", "initiallySelectedWord", "Lkotlin/Pair;", "getInitiallySelectedWord", "()Lkotlin/Pair;", "setInitiallySelectedWord", "(Lkotlin/Pair;)V", "lastSelectionMoveTimestamp", "", "getLastSelectionMoveTimestamp", "()J", "setLastSelectionMoveTimestamp", "(J)V", "lineHeight", "getLineHeight", "setLineHeight", "otherSelectionEnd", "getOtherSelectionEnd", "setOtherSelectionEnd", "getPlaceholder", "()Ljava/lang/String;", "setPlaceholder", "(Ljava/lang/String;)V", "redoStack", "Ljava/util/ArrayDeque;", "Lgg/essential/elementa/components/input/AbstractTextInput$TextOperation;", "getRedoStack", "()Ljava/util/ArrayDeque;", "getSelectionBackgroundColor", "getSelectionForegroundColor", "selectionMode", "Lgg/essential/elementa/components/input/AbstractTextInput$SelectionMode;", "getSelectionMode", "()Lgg/essential/elementa/components/input/AbstractTextInput$SelectionMode;", "setSelectionMode", "(Lgg/essential/elementa/components/input/AbstractTextInput$SelectionMode;)V", "getShadow", "setShadow", "targetVerticalScrollingOffset", "getTargetVerticalScrollingOffset", "setTargetVerticalScrollingOffset", "textualLines", "", "Lgg/essential/elementa/components/input/AbstractTextInput$TextualLine;", "getTextualLines", "()Ljava/util/List;", "undoStack", "getUndoStack", "updateAction", "getUpdateAction", "setUpdateAction", "verticalScrollingOffset", "getVerticalScrollingOffset", "setVerticalScrollingOffset", "visualLines", "Lgg/essential/elementa/components/input/AbstractTextInput$VisualLine;", "getVisualLines", "addText", "newText", "position", "animateCursor", "animationFrame", "charAfter", "", "pos", "(Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;)Ljava/lang/Character;", "charBefore", "commitTextAddition", "commitTextOperation", "operation", "commitTextRemoval", "startPos", "endPos", "selectAfterUndo", "copySelection", "deleteSelection", "draw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawSelectedText", "left", "right", "row", "drawSelectedTextCompat", "drawUnselectedText", "drawUnselectedTextCompat", "getNearestWordBoundary", "direction", "Lgg/essential/elementa/components/input/AbstractTextInput$Direction;", "getSelection", "getText", "getTextBetween", "hasSelection", "hasText", "isActive", "isBreakingCharacter", "ch", "onActivate", "listener", "onEnterPressed", "onUpdate", "recalculateAllVisualLines", "recalculateDimensions", "recalculateVisualLinesFor", "textualLineIndex", "removeText", "screenPosToVisualPos", "x", "y", "scrollIntoView", "selectAll", "selectionEnd", "selectionStart", "setCursorPosition", "newPosition", "setText", "splitTextForWrapping", "", "maxLineWidth", "textToLines", "AddTextOperation", "Companion", "Direction", "Line", "LinePosition", "RemoveTextOperation", "ReplaceTextOperation", "SelectionMode", "TextOperation", "TextualLine", "VisualLine", "Elementa"})
@SourceDebugExtension(value={"SMAP\nAbstractTextInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTextInput.kt\ngg/essential/elementa/components/input/AbstractTextInput\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 animations.kt\ngg/essential/elementa/dsl/AnimationsKt\n*L\n1#1,988:1\n9#2,3:989\n1547#3:992\n1618#3,3:993\n1547#3:996\n1618#3,3:997\n1547#3:1000\n1618#3,3:1001\n1#4:1004\n10#5,5:1005\n*S KotlinDebug\n*F\n+ 1 AbstractTextInput.kt\ngg/essential/elementa/components/input/AbstractTextInput\n*L\n53#1:989,3\n435#1:992\n435#1:993,3\n464#1:996\n464#1:997,3\n475#1:1000\n475#1:1001,3\n672#1:1005,5\n*E\n"})
public abstract class AbstractTextInput
extends UIComponent {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private String placeholder;
    private boolean shadow;
    @NotNull
    private final Color selectionBackgroundColor;
    @NotNull
    private final Color selectionForegroundColor;
    private final boolean allowInactiveSelection;
    @NotNull
    private final Color inactiveSelectionBackgroundColor;
    @NotNull
    private final Color inactiveSelectionForegroundColor;
    @NotNull
    private final Color cursorColor;
    private boolean active;
    private float lineHeight;
    @NotNull
    private Function1<? super String, Unit> updateAction;
    @NotNull
    private Function1<? super String, Unit> activateAction;
    @NotNull
    private final List<TextualLine> textualLines;
    @NotNull
    private final List<VisualLine> visualLines;
    private float verticalScrollingOffset;
    private float targetVerticalScrollingOffset;
    private float horizontalScrollingOffset;
    private boolean cursorNeedsRefocus;
    private long lastSelectionMoveTimestamp;
    @NotNull
    private SelectionMode selectionMode;
    private int initiallySelectedLine;
    @NotNull
    private Pair<LinePosition, LinePosition> initiallySelectedWord;
    @NotNull
    private final ArrayDeque<TextOperation> undoStack;
    @NotNull
    private final ArrayDeque<TextOperation> redoStack;
    @NotNull
    private UIComponent cursorComponent;
    @NotNull
    private LinePosition cursor;
    @NotNull
    private LinePosition otherSelectionEnd;

    /*
     * WARNING - void declaration
     */
    public AbstractTextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor) {
        void $this$cursorComponent_u24lambda_u240;
        UIComponent uIComponent;
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionBackgroundColor, "inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionForegroundColor, "inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter(cursorColor, "cursorColor");
        this.placeholder = placeholder;
        this.shadow = shadow;
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.selectionForegroundColor = selectionForegroundColor;
        this.allowInactiveSelection = allowInactiveSelection;
        this.inactiveSelectionBackgroundColor = inactiveSelectionBackgroundColor;
        this.inactiveSelectionForegroundColor = inactiveSelectionForegroundColor;
        this.cursorColor = cursorColor;
        this.lineHeight = 9.0f;
        this.updateAction = updateAction.1.INSTANCE;
        this.activateAction = activateAction.1.INSTANCE;
        Line[] lineArray = new TextualLine[]{new TextualLine(this, "", new IntRange(0, 0))};
        this.textualLines = CollectionsKt.mutableListOf(lineArray);
        lineArray = new VisualLine[]{new VisualLine("", 0)};
        this.visualLines = CollectionsKt.mutableListOf(lineArray);
        this.lastSelectionMoveTimestamp = System.currentTimeMillis();
        this.selectionMode = SelectionMode.None;
        this.initiallySelectedLine = -1;
        this.initiallySelectedWord = TuplesKt.to(new LinePosition(0, 0, true), new LinePosition(0, 0, true));
        this.undoStack = new ArrayDeque();
        this.redoStack = new ArrayDeque();
        UIComponent $this$constrain$iv = new UIBlock(new Color(255, 255, 255, 0));
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints uIConstraints = $this$constrain_u24lambda_u240$iv.getConstraints();
        AbstractTextInput abstractTextInput = this;
        boolean bl2 = false;
        $this$cursorComponent_u24lambda_u240.setY(ConstraintsKt.minus(new CenterConstraint(), UtilitiesKt.pixels$default(Float.valueOf(0.5f), false, false, 3, null)));
        $this$cursorComponent_u24lambda_u240.setWidth(UtilitiesKt.pixel$default(1, false, false, 3, null));
        $this$cursorComponent_u24lambda_u240.setHeight(UtilitiesKt.pixels$default(Float.valueOf(this.lineHeight), false, false, 3, null));
        abstractTextInput.cursorComponent = ComponentsKt.childOf(uIComponent, this);
        this.cursor = new LinePosition(0, 0, true);
        this.otherSelectionEnd = new LinePosition(0, 0, true);
        this.setHeight(UtilitiesKt.pixels$default(Float.valueOf(this.lineHeight), false, false, 3, null));
        this.onKeyType((Function3<? super UIComponent, ? super Character, ? super Integer, Unit>)new Function3<UIComponent, Character, Integer, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent $this$onKeyType, char typedChar, int keyCode) {
                Intrinsics.checkNotNullParameter($this$onKeyType, "$this$onKeyType");
                if (!this.getActive()) {
                    return;
                }
                if (keyCode == UKeyboard.KEY_ESCAPE) {
                    $this$onKeyType.releaseWindowFocus();
                } else if (UKeyboard.isKeyComboCtrlA(keyCode)) {
                    this.selectAll();
                } else if (UKeyboard.isKeyComboCtrlC(keyCode) && this.hasSelection()) {
                    this.copySelection();
                } else if (UKeyboard.isKeyComboCtrlX(keyCode) && this.hasSelection()) {
                    this.copySelection();
                    this.deleteSelection();
                } else if (UKeyboard.isKeyComboCtrlV(keyCode)) {
                    this.commitTextAddition(UDesktop.getClipboardString());
                } else if (UKeyboard.isKeyComboCtrlZ(keyCode)) {
                    if (this.getUndoStack().isEmpty()) {
                        return;
                    }
                    TextOperation operationToUndo = this.getUndoStack().pop();
                    operationToUndo.undo();
                    this.getRedoStack().push(operationToUndo);
                } else if (UKeyboard.isKeyComboCtrlShiftZ(keyCode) || UKeyboard.isKeyComboCtrlY(keyCode)) {
                    if (this.getRedoStack().isEmpty()) {
                        return;
                    }
                    TextOperation operationToRedo = this.getRedoStack().pop();
                    operationToRedo.redo();
                    this.getUndoStack().push(operationToRedo);
                } else if (Companion.isAllowedCharacter(typedChar)) {
                    this.commitTextAddition(String.valueOf(typedChar));
                } else if (keyCode == UKeyboard.KEY_LEFT) {
                    LinePosition newCursorPosition;
                    boolean holdingShift = UKeyboard.isShiftKeyDown();
                    boolean holdingCtrl = UKeyboard.isCtrlKeyDown();
                    LinePosition linePosition = holdingCtrl ? this.getNearestWordBoundary(this.getCursor(), Direction.Left) : (this.hasSelection() ? (holdingShift ? this.getCursor().offsetColumn(-1) : this.selectionStart()) : (newCursorPosition = this.getCursor().offsetColumn(-1)));
                    if (!holdingShift) {
                        this.setCursorPosition(newCursorPosition);
                        return;
                    }
                    this.setCursor(newCursorPosition);
                    this.setCursorNeedsRefocus(true);
                } else if (keyCode == UKeyboard.KEY_RIGHT) {
                    LinePosition newCursorPosition;
                    boolean holdingShift = UKeyboard.isShiftKeyDown();
                    boolean holdingCtrl = UKeyboard.isCtrlKeyDown();
                    LinePosition linePosition = holdingCtrl ? this.getNearestWordBoundary(this.getCursor(), Direction.Right) : (this.hasSelection() ? (holdingShift ? this.getCursor().offsetColumn(1) : this.selectionEnd()) : (newCursorPosition = this.getCursor().offsetColumn(1)));
                    if (!holdingShift) {
                        this.setCursorPosition(newCursorPosition);
                        return;
                    }
                    this.setCursor(newCursorPosition);
                    this.setCursorNeedsRefocus(true);
                } else if (keyCode == UKeyboard.KEY_UP) {
                    LinePosition newVisualPos;
                    LinePosition linePosition;
                    if (this.getCursor().getLine() == 0) {
                        linePosition = new LinePosition(0, 0, true);
                    } else {
                        Pair<Float, Float> holdingCtrl = this.getCursor().toScreenPos();
                        float currX = ((Number)holdingCtrl.component1()).floatValue();
                        float currY = ((Number)holdingCtrl.component2()).floatValue();
                        linePosition = newVisualPos = this.screenPosToVisualPos(currX, currY - this.getLineHeight());
                    }
                    if (UKeyboard.isShiftKeyDown()) {
                        this.setCursor(newVisualPos);
                        this.setCursorNeedsRefocus(true);
                    } else {
                        this.setCursorPosition(newVisualPos);
                    }
                } else if (keyCode == UKeyboard.KEY_DOWN) {
                    LinePosition newVisualPos;
                    LinePosition linePosition;
                    if (this.getCursor().getLine() == CollectionsKt.getLastIndex(this.getVisualLines())) {
                        linePosition = new LinePosition(CollectionsKt.getLastIndex(this.getVisualLines()), CollectionsKt.last(this.getVisualLines()).getLength(), true);
                    } else {
                        Pair<Float, Float> holdingCtrl = this.getCursor().toScreenPos();
                        float currX = ((Number)holdingCtrl.component1()).floatValue();
                        float currY = ((Number)holdingCtrl.component2()).floatValue();
                        linePosition = newVisualPos = this.screenPosToVisualPos(currX, currY + this.getLineHeight());
                    }
                    if (UKeyboard.isShiftKeyDown()) {
                        this.setCursor(newVisualPos);
                        this.setCursorNeedsRefocus(true);
                    } else {
                        this.setCursorPosition(newVisualPos);
                    }
                } else if (keyCode == UKeyboard.KEY_BACKSPACE) {
                    if (this.hasSelection()) {
                        this.deleteSelection();
                    } else if (!this.getCursor().isAtAbsoluteStart()) {
                        LinePosition startPos = UKeyboard.isCtrlKeyDown() ? this.getNearestWordBoundary(this.getCursor(), Direction.Left) : this.getCursor().offsetColumn(-1).toTextualPos();
                        LinePosition endPos = this.getCursor().toTextualPos();
                        this.commitTextRemoval(startPos, endPos, false);
                    }
                } else if (keyCode == UKeyboard.KEY_DELETE) {
                    if (this.hasSelection()) {
                        this.deleteSelection();
                    } else if (!this.getCursor().isAtAbsoluteEnd()) {
                        LinePosition startPos = this.getCursor().toTextualPos();
                        LinePosition endPos = UKeyboard.isCtrlKeyDown() ? this.getNearestWordBoundary(this.getCursor(), Direction.Right) : this.getCursor().offsetColumn(1).toTextualPos();
                        this.commitTextRemoval(startPos, endPos, false);
                    }
                } else if (keyCode == UKeyboard.KEY_HOME) {
                    if (UKeyboard.isShiftKeyDown()) {
                        this.setCursor(this.getCursor().withColumn(0));
                        this.setCursorNeedsRefocus(true);
                    } else {
                        this.setCursorPosition(this.getCursor().withColumn(0));
                    }
                } else if (keyCode == UKeyboard.KEY_END) {
                    LinePosition linePosition = this.getCursor().withColumn(this.getVisualLines().get(this.getCursor().getLine()).getLength());
                    AbstractTextInput abstractTextInput = this;
                    LinePosition it = linePosition;
                    boolean bl = false;
                    if (UKeyboard.isShiftKeyDown()) {
                        abstractTextInput.setCursor(it);
                        abstractTextInput.setCursorNeedsRefocus(true);
                    } else {
                        abstractTextInput.setCursorPosition(it);
                    }
                } else if (keyCode == UKeyboard.KEY_ENTER) {
                    this.onEnterPressed();
                }
            }
        });
        this.onMouseScroll((Function2<? super UIComponent, ? super UIScrollEvent, Unit>)new Function2<UIComponent, UIScrollEvent, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent $this$onMouseScroll, @NotNull UIScrollEvent it) {
                Intrinsics.checkNotNullParameter($this$onMouseScroll, "$this$onMouseScroll");
                Intrinsics.checkNotNullParameter(it, "it");
                float heightDifference = $this$onMouseScroll.getHeight() - (float)this.getVisualLines().size() * this.getLineHeight();
                if (heightDifference > 0.0f) {
                    return;
                }
                this.setTargetVerticalScrollingOffset(RangesKt.coerceIn(this.getTargetVerticalScrollingOffset() + (float)it.getDelta() * this.getLineHeight(), heightDifference, 0.0f));
                it.stopPropagation();
            }
        });
        this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)new Function2<UIComponent, UIClickEvent, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent event) {
                Intrinsics.checkNotNullParameter($this$onMouseClick, "$this$onMouseClick");
                Intrinsics.checkNotNullParameter(event, "event");
                if (!this.getActive() || event.getMouseButton() != 0) {
                    return;
                }
                LinePosition clickedVisualPos = this.screenPosToVisualPos(event.getRelativeX(), event.getRelativeY());
                int clickCount = event.getClickCount() % 3;
                if (clickCount == 0 && clickedVisualPos.getLine() != this.getCursor().getLine()) {
                    clickCount = 1;
                } else if (clickCount == 2 && !Intrinsics.areEqual(this.getCursor(), clickedVisualPos)) {
                    clickCount = 1;
                }
                switch (clickCount) {
                    case 0: {
                        this.setSelectionMode(SelectionMode.Line);
                        this.setOtherSelectionEnd(clickedVisualPos.withColumn(this.getVisualLines().get(this.getCursor().getLine()).getLength()));
                        this.setInitiallySelectedLine(this.getCursor().getLine());
                        break;
                    }
                    case 1: {
                        this.setSelectionMode(SelectionMode.Character);
                        this.setCursorPosition(clickedVisualPos);
                        break;
                    }
                    case 2: {
                        this.setSelectionMode(SelectionMode.Word);
                        this.setCursor(this.getNearestWordBoundary(clickedVisualPos, Direction.Left));
                        this.setCursorNeedsRefocus(true);
                        this.setOtherSelectionEnd(this.getNearestWordBoundary(clickedVisualPos, Direction.Right));
                        this.setInitiallySelectedWord(TuplesKt.to(this.getCursor(), this.getOtherSelectionEnd()));
                    }
                }
            }
        });
        this.onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)new Function4<UIComponent, Float, Float, Integer, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent $this$onMouseDrag, float mouseX, float mouseY, int mouseButton) {
                Intrinsics.checkNotNullParameter($this$onMouseDrag, "$this$onMouseDrag");
                if (mouseButton != 0 || this.getSelectionMode() == SelectionMode.None) {
                    return;
                }
                LinePosition draggedVisualPos = this.screenPosToVisualPos(mouseX, mouseY);
                switch (WhenMappings.$EnumSwitchMapping$0[this.getSelectionMode().ordinal()]) {
                    case 1: {
                        this.setOtherSelectionEnd(draggedVisualPos);
                        break;
                    }
                    case 2: {
                        if (this.getInitiallySelectedLine() < draggedVisualPos.getLine()) {
                            this.setCursor(new LinePosition(this.getInitiallySelectedLine(), 0, true));
                            this.setOtherSelectionEnd(draggedVisualPos.withColumn(this.getVisualLines().get(draggedVisualPos.getLine()).getLength()));
                            break;
                        }
                        this.setCursor(draggedVisualPos.withColumn(0));
                        this.setOtherSelectionEnd(new LinePosition(this.getInitiallySelectedLine(), this.getVisualLines().get(this.getInitiallySelectedLine()).getLength(), true));
                        break;
                    }
                    case 3: {
                        if (draggedVisualPos.compareTo(this.getInitiallySelectedWord().getFirst()) < 0) {
                            this.setCursor(this.getNearestWordBoundary(draggedVisualPos, Direction.Left));
                            this.setOtherSelectionEnd(this.getInitiallySelectedWord().getSecond());
                            break;
                        }
                        if (draggedVisualPos.compareTo(this.getInitiallySelectedWord().getSecond()) > 0) {
                            this.setCursor(this.getInitiallySelectedWord().getFirst());
                            this.setOtherSelectionEnd(this.getNearestWordBoundary(draggedVisualPos, Direction.Right));
                            break;
                        }
                        this.setCursor(this.getInitiallySelectedWord().getFirst());
                        this.setOtherSelectionEnd(this.getInitiallySelectedWord().getSecond());
                    }
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.getLastSelectionMoveTimestamp() > (long)50) {
                    if (mouseY <= 0.0f) {
                        this.setTargetVerticalScrollingOffset(RangesKt.coerceAtMost(this.getTargetVerticalScrollingOffset() + this.getLineHeight() * $this$onMouseDrag.getTextScale(), 0.0f));
                        this.setLastSelectionMoveTimestamp(currentTime);
                    } else if (mouseY >= $this$onMouseDrag.getHeight()) {
                        float heightDifference = $this$onMouseDrag.getHeight() - (float)this.getVisualLines().size() * this.getLineHeight() * $this$onMouseDrag.getTextScale();
                        this.setTargetVerticalScrollingOffset(RangesKt.coerceIn(this.getTargetVerticalScrollingOffset() - this.getLineHeight() * $this$onMouseDrag.getTextScale(), 0.0f, heightDifference));
                        this.setLastSelectionMoveTimestamp(currentTime);
                    } else if (mouseX <= 0.0f) {
                        this.scrollIntoView(draggedVisualPos.offsetColumn(-1));
                        this.setLastSelectionMoveTimestamp(currentTime);
                    } else if (mouseX >= $this$onMouseDrag.getWidth()) {
                        this.scrollIntoView(draggedVisualPos.offsetColumn(1));
                        this.setLastSelectionMoveTimestamp(currentTime);
                    }
                }
            }

            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[SelectionMode.values().length];
                    try {
                        nArray[SelectionMode.Character.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelectionMode.Line.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelectionMode.Word.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelectionMode.None.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        this.onMouseRelease((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter($this$onMouseRelease, "$this$onMouseRelease");
                this.setSelectionMode(SelectionMode.None);
            }
        });
        this.onFocus((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent $this$onFocus) {
                Intrinsics.checkNotNullParameter($this$onFocus, "$this$onFocus");
                this.setActive(true);
            }
        });
        this.onFocusLost((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent $this$onFocusLost) {
                Intrinsics.checkNotNullParameter($this$onFocusLost, "$this$onFocusLost");
                this.setActive(false);
            }
        });
        this.cursorComponent.animateAfterUnhide((Function1<? super AnimatingConstraints, Unit>)new Function1<AnimatingConstraints, Unit>(){

            @Override
            public final void invoke(@NotNull AnimatingConstraints $this$animateAfterUnhide) {
                Intrinsics.checkNotNullParameter($this$animateAfterUnhide, "$this$animateAfterUnhide");
                AnimatingConstraints.setColorAnimation$default($this$animateAfterUnhide, Animations.OUT_CIRCULAR, 0.5f, UtilitiesKt.toConstraint(this.getCursorColor()), 0.0f, 8, null);
                $this$animateAfterUnhide.onComplete(new Function0<Unit>(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void invoke() {
                        AnimatingConstraints anim$iv;
                        void $this$animate$iv;
                        void var4_4;
                        if (!this.getActive()) {
                            return;
                        }
                        UIComponent uIComponent = this.getCursorComponent();
                        AbstractTextInput abstractTextInput = this;
                        boolean $i$f$animate = false;
                        void $this$animate_u24lambda_u240$iv = var4_4 = $this$animate$iv;
                        boolean bl = false;
                        AnimatingConstraints $this$invoke_u24lambda_u240 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
                        boolean bl2 = false;
                        AnimatingConstraints.setColorAnimation$default($this$invoke_u24lambda_u240, Animations.IN_CIRCULAR, 0.5f, UtilitiesKt.toConstraint(new Color(255, 255, 255, 0)), 0.0f, 8, null);
                        $this$invoke_u24lambda_u240.onComplete(new Function0<Unit>(abstractTextInput){
                            final /* synthetic */ AbstractTextInput this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                if (this.this$0.getActive()) {
                                    this.this$0.animateCursor();
                                }
                            }
                        });
                        $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
                    }
                });
            }
        });
        this.enableEffect(new ScissorEffect(null, false, 3, null));
    }

    @NotNull
    public final String getPlaceholder() {
        return this.placeholder;
    }

    public final void setPlaceholder(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.placeholder = string;
    }

    public final boolean getShadow() {
        return this.shadow;
    }

    public final void setShadow(boolean bl) {
        this.shadow = bl;
    }

    @NotNull
    protected final Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    @NotNull
    protected final Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    protected final boolean getAllowInactiveSelection() {
        return this.allowInactiveSelection;
    }

    @NotNull
    protected final Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    @NotNull
    protected final Color getInactiveSelectionForegroundColor() {
        return this.inactiveSelectionForegroundColor;
    }

    @NotNull
    protected final Color getCursorColor() {
        return this.cursorColor;
    }

    protected final boolean getActive() {
        return this.active;
    }

    protected final void setActive(boolean bl) {
        this.active = bl;
    }

    public final float getLineHeight() {
        return this.lineHeight;
    }

    public final void setLineHeight(float value) {
        this.cursorComponent.setHeight(UtilitiesKt.pixels$default(Float.valueOf(value), false, false, 3, null));
        this.setHeight(UtilitiesKt.pixels$default(Float.valueOf(value), false, false, 3, null));
        this.lineHeight = value;
    }

    @NotNull
    protected final Function1<String, Unit> getUpdateAction() {
        return this.updateAction;
    }

    protected final void setUpdateAction(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.updateAction = function1;
    }

    @NotNull
    protected final Function1<String, Unit> getActivateAction() {
        return this.activateAction;
    }

    protected final void setActivateAction(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.activateAction = function1;
    }

    @NotNull
    protected final List<TextualLine> getTextualLines() {
        return this.textualLines;
    }

    @NotNull
    protected final List<VisualLine> getVisualLines() {
        return this.visualLines;
    }

    protected final float getVerticalScrollingOffset() {
        return this.verticalScrollingOffset;
    }

    protected final void setVerticalScrollingOffset(float f) {
        this.verticalScrollingOffset = f;
    }

    protected final float getTargetVerticalScrollingOffset() {
        return this.targetVerticalScrollingOffset;
    }

    protected final void setTargetVerticalScrollingOffset(float f) {
        this.targetVerticalScrollingOffset = f;
    }

    protected final float getHorizontalScrollingOffset() {
        return this.horizontalScrollingOffset;
    }

    protected final void setHorizontalScrollingOffset(float f) {
        this.horizontalScrollingOffset = f;
    }

    protected final boolean getCursorNeedsRefocus() {
        return this.cursorNeedsRefocus;
    }

    protected final void setCursorNeedsRefocus(boolean bl) {
        this.cursorNeedsRefocus = bl;
    }

    protected final long getLastSelectionMoveTimestamp() {
        return this.lastSelectionMoveTimestamp;
    }

    protected final void setLastSelectionMoveTimestamp(long l) {
        this.lastSelectionMoveTimestamp = l;
    }

    @NotNull
    protected final SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    protected final void setSelectionMode(@NotNull SelectionMode selectionMode) {
        Intrinsics.checkNotNullParameter((Object)selectionMode, "<set-?>");
        this.selectionMode = selectionMode;
    }

    protected final int getInitiallySelectedLine() {
        return this.initiallySelectedLine;
    }

    protected final void setInitiallySelectedLine(int n) {
        this.initiallySelectedLine = n;
    }

    @NotNull
    protected final Pair<LinePosition, LinePosition> getInitiallySelectedWord() {
        return this.initiallySelectedWord;
    }

    protected final void setInitiallySelectedWord(@NotNull Pair<LinePosition, LinePosition> pair) {
        Intrinsics.checkNotNullParameter(pair, "<set-?>");
        this.initiallySelectedWord = pair;
    }

    @NotNull
    protected final ArrayDeque<TextOperation> getUndoStack() {
        return this.undoStack;
    }

    @NotNull
    protected final ArrayDeque<TextOperation> getRedoStack() {
        return this.redoStack;
    }

    @NotNull
    protected final UIComponent getCursorComponent() {
        return this.cursorComponent;
    }

    protected final void setCursorComponent(@NotNull UIComponent uIComponent) {
        Intrinsics.checkNotNullParameter(uIComponent, "<set-?>");
        this.cursorComponent = uIComponent;
    }

    @NotNull
    protected final LinePosition getCursor() {
        return this.cursor;
    }

    protected final void setCursor(@NotNull LinePosition value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.cursor = value.toVisualPos();
    }

    @NotNull
    protected final LinePosition getOtherSelectionEnd() {
        return this.otherSelectionEnd;
    }

    protected final void setOtherSelectionEnd(@NotNull LinePosition value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.otherSelectionEnd = value.toVisualPos();
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        this.cursorComponent.setHeight(UtilitiesKt.pixels$default(Float.valueOf(this.lineHeight * this.getTextScale()), false, false, 3, null));
        super.draw(matrixStack);
    }

    @NotNull
    public abstract String getText();

    public final void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        LinePosition absoluteStart = new LinePosition(0, 0, true);
        ReplaceTextOperation replaceTextOperation = new ReplaceTextOperation(new AddTextOperation(text, absoluteStart), new RemoveTextOperation(absoluteStart, new LinePosition(CollectionsKt.getLastIndex(this.visualLines), CollectionsKt.last(this.visualLines).getLength(), true), true));
        this.commitTextOperation(replaceTextOperation);
    }

    protected abstract void scrollIntoView(@NotNull LinePosition var1);

    @NotNull
    protected abstract LinePosition screenPosToVisualPos(float var1, float var2);

    protected abstract void recalculateDimensions();

    @NotNull
    protected abstract List<String> textToLines(@NotNull String var1);

    protected abstract void onEnterPressed();

    @NotNull
    public final AbstractTextInput setActive(boolean isActive) {
        AbstractTextInput abstractTextInput;
        AbstractTextInput $this$setActive_u24lambda_u241 = abstractTextInput = this;
        boolean bl = false;
        $this$setActive_u24lambda_u241.active = isActive;
        if (isActive) {
            UIComponent.unhide$default($this$setActive_u24lambda_u241.cursorComponent, false, 1, null);
            $this$setActive_u24lambda_u241.animateCursor();
        } else {
            $this$setActive_u24lambda_u241.cursorComponent.setColor(UtilitiesKt.toConstraint(new Color(255, 255, 255, 0)));
            if (!(!$this$setActive_u24lambda_u241.hasText() || $this$setActive_u24lambda_u241.allowInactiveSelection && $this$setActive_u24lambda_u241.hasSelection())) {
                $this$setActive_u24lambda_u241.setCursorPosition($this$setActive_u24lambda_u241.new LinePosition(CollectionsKt.getLastIndex($this$setActive_u24lambda_u241.visualLines), CollectionsKt.last($this$setActive_u24lambda_u241.visualLines).getLength(), true));
            }
        }
        return abstractTextInput;
    }

    public final boolean isActive() {
        return this.active;
    }

    @NotNull
    public final AbstractTextInput onUpdate(@NotNull Function1<? super String, Unit> listener2) {
        AbstractTextInput abstractTextInput;
        Intrinsics.checkNotNullParameter(listener2, "listener");
        AbstractTextInput $this$onUpdate_u24lambda_u242 = abstractTextInput = this;
        boolean bl = false;
        $this$onUpdate_u24lambda_u242.updateAction = listener2;
        return abstractTextInput;
    }

    @NotNull
    public final AbstractTextInput onActivate(@NotNull Function1<? super String, Unit> listener2) {
        AbstractTextInput abstractTextInput;
        Intrinsics.checkNotNullParameter(listener2, "listener");
        AbstractTextInput $this$onActivate_u24lambda_u243 = abstractTextInput = this;
        boolean bl = false;
        $this$onActivate_u24lambda_u243.activateAction = listener2;
        return abstractTextInput;
    }

    protected void commitTextOperation(@NotNull TextOperation operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        operation.redo();
        this.undoStack.push(operation);
        this.redoStack.clear();
    }

    protected final void commitTextAddition(@NotNull String newText) {
        Intrinsics.checkNotNullParameter(newText, "newText");
        AddTextOperation addTextOperation = new AddTextOperation(newText, this.cursor);
        if (this.hasSelection()) {
            RemoveTextOperation removeTextOperation = new RemoveTextOperation(this.selectionStart(), this.selectionEnd(), true);
            ReplaceTextOperation replaceTextOperation = new ReplaceTextOperation(addTextOperation, removeTextOperation);
            this.commitTextOperation(replaceTextOperation);
            return;
        }
        this.commitTextOperation(addTextOperation);
    }

    /*
     * WARNING - void declaration
     */
    protected final void addText(@NotNull String newText, @NotNull LinePosition position) {
        Intrinsics.checkNotNullParameter(newText, "newText");
        Intrinsics.checkNotNullParameter(position, "position");
        LinePosition textPos = position.toTextualPos();
        TextualLine textualLine = this.textualLines.get(textPos.getLine());
        List<String> lines = this.textToLines(newText);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.size() == 1) {
            textualLine.addTextAt(CollectionsKt.first(lines), textPos.getColumn());
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)lines, 1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new TextualLine(this, (String)it, null, 2, null));
            }
            List newTextualLines = (List)destination$iv$iv;
            if (textPos.getColumn() < textualLine.getText().length()) {
                Object object = textualLine.getText();
                int n = textPos.getColumn();
                String string = object;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).substring(startIndex)");
                String textAfterInsertion = string2;
                StringBuilder stringBuilder = new StringBuilder();
                object = textualLine.getText();
                n = 0;
                int n2 = textPos.getColumn();
                String string3 = object;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                textualLine.setText(stringBuilder.append(string4).append(CollectionsKt.first(lines)).toString());
                object = (TextualLine)CollectionsKt.last(newTextualLines);
                ((Line)object).setText(((Line)object).getText() + textAfterInsertion);
            } else {
                textualLine.addTextAt(CollectionsKt.first(lines), textPos.getColumn());
            }
            this.textualLines.addAll(textPos.getLine() + 1, newTextualLines);
        }
        this.recalculateAllVisualLines();
        this.setCursorPosition(textPos.offsetColumn(newText.length()).toVisualPos());
        this.updateAction.invoke(this.getText());
    }

    /*
     * WARNING - void declaration
     */
    protected void recalculateVisualLinesFor(int textualLineIndex) {
        Collection<VisualLine> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TextualLine textualLine = this.textualLines.get(textualLineIndex);
        int firstVisualIndex = textualLine.getVisualIndices().getFirst();
        int n = CollectionsKt.count(textualLine.getVisualIndices());
        int n2 = n;
        for (int j = 0; j < n2; ++j) {
            int it = j;
            boolean bl = false;
            if (firstVisualIndex >= this.visualLines.size()) continue;
            this.visualLines.remove(firstVisualIndex);
        }
        List<String> splitLines = this.splitTextForWrapping(textualLine.getText(), this.getWidth());
        Iterable iterable = splitLines;
        int n3 = firstVisualIndex;
        List<VisualLine> list = this.visualLines;
        boolean $i$f$map = false;
        void it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new VisualLine((String)it2, textualLineIndex));
        }
        collection = (List)destination$iv$iv;
        list.addAll(n3, collection);
        textualLine.setVisualIndices(RangesKt.until(firstVisualIndex, firstVisualIndex + splitLines.size()));
    }

    /*
     * WARNING - void declaration
     */
    protected void recalculateAllVisualLines() {
        this.visualLines.clear();
        Iterator<TextualLine> iterator2 = this.textualLines.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int index = n++;
            TextualLine textualLine = iterator2.next();
            List<String> splitLines = this.splitTextForWrapping(textualLine.getText(), this.getWidth());
            textualLine.setVisualIndices(new IntRange(this.visualLines.size(), this.visualLines.size() + splitLines.size()));
            Iterable iterable = splitLines;
            List<VisualLine> list = this.visualLines;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new VisualLine((String)it, index));
            }
            list.addAll((List)destination$iv$iv);
        }
    }

    @NotNull
    protected List<String> splitTextForWrapping(@NotNull String text, float maxLineWidth) {
        Intrinsics.checkNotNullParameter(text, "text");
        return TextKt.getStringSplitToWidth$default(text, maxLineWidth, this.getTextScale(), false, false, null, 40, null);
    }

    protected final void commitTextRemoval(@NotNull LinePosition startPos, @NotNull LinePosition endPos, boolean selectAfterUndo) {
        Intrinsics.checkNotNullParameter(startPos, "startPos");
        Intrinsics.checkNotNullParameter(endPos, "endPos");
        RemoveTextOperation removeTextOperation = new RemoveTextOperation(startPos, endPos, selectAfterUndo);
        this.commitTextOperation(removeTextOperation);
    }

    private final void removeText(LinePosition startPos, LinePosition endPos) {
        LinePosition textualStartPos = startPos.toTextualPos();
        LinePosition textualEndPos = endPos.toTextualPos();
        TextualLine startTextualLine = this.textualLines.get(textualStartPos.getLine());
        TextualLine endTextualLine = this.textualLines.get(textualEndPos.getLine());
        StringBuilder stringBuilder = new StringBuilder();
        String string = startTextualLine.getText();
        int n = 0;
        int n2 = textualStartPos.getColumn();
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        string = endTextualLine.getText();
        n = textualEndPos.getColumn();
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).substring(startIndex)");
        startTextualLine.setText(stringBuilder2.append(string5).toString());
        int firstItemToDelete = textualStartPos.getLine() + 1;
        n = textualEndPos.getLine() - firstItemToDelete + 1;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl = false;
            this.textualLines.remove(firstItemToDelete);
        }
        this.recalculateAllVisualLines();
        float heightDifference = this.getHeight() - (float)this.visualLines.size() * this.lineHeight;
        if (this.verticalScrollingOffset < heightDifference) {
            this.targetVerticalScrollingOffset = RangesKt.coerceAtMost(heightDifference, 0.0f);
        }
        this.updateAction.invoke(this.getText());
    }

    private final void setCursorPosition(LinePosition newPosition) {
        LinePosition linePosition;
        LinePosition $this$setCursorPosition_u24lambda_u249 = linePosition = newPosition.toVisualPos();
        boolean bl = false;
        this.setCursor($this$setCursorPosition_u24lambda_u249);
        this.setOtherSelectionEnd($this$setCursorPosition_u24lambda_u249);
        this.cursorNeedsRefocus = true;
    }

    @NotNull
    protected String getTextBetween(@NotNull LinePosition startPos, @NotNull LinePosition endPos) {
        String string;
        Intrinsics.checkNotNullParameter(startPos, "startPos");
        Intrinsics.checkNotNullParameter(endPos, "endPos");
        LinePosition textStart = startPos.toTextualPos();
        LinePosition textEnd = endPos.toTextualPos();
        if (textStart.getLine() == textEnd.getLine()) {
            String string2 = this.textualLines.get(textStart.getLine()).getText();
            int n = textStart.getColumn();
            int n2 = textEnd.getColumn();
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            List lines = new ArrayList();
            String string5 = this.textualLines.get(textStart.getLine()).getText();
            int n = textStart.getColumn();
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue(string7, "(this as java.lang.String).substring(startIndex)");
            lines.add(string7);
            n = textEnd.getLine();
            for (int i2 = textStart.getLine() + 1; i2 < n; ++i2) {
                lines.add(this.textualLines.get(i2).getText());
            }
            String string8 = this.textualLines.get(textEnd.getLine()).getText();
            n = 0;
            int n3 = textEnd.getColumn();
            String string9 = string8;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue(string10, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            lines.add(string10);
            string = CollectionsKt.joinToString$default(lines, "\n", null, null, 0, null, null, 62, null);
        }
        return string;
    }

    protected void selectAll() {
        this.setCursor(new LinePosition(0, 0, true));
        this.setOtherSelectionEnd(new LinePosition(this.visualLines.size() - 1, CollectionsKt.last(this.visualLines).getLength(), true));
    }

    protected boolean hasSelection() {
        return !Intrinsics.areEqual(this.cursor, this.otherSelectionEnd);
    }

    @NotNull
    protected LinePosition selectionStart() {
        return (LinePosition)ComparisonsKt.minOf((Comparable)this.cursor, (Comparable)this.otherSelectionEnd);
    }

    @NotNull
    protected LinePosition selectionEnd() {
        return (LinePosition)ComparisonsKt.maxOf((Comparable)this.cursor, (Comparable)this.otherSelectionEnd);
    }

    @NotNull
    protected Pair<LinePosition, LinePosition> getSelection() {
        return TuplesKt.to(this.selectionStart(), this.selectionEnd());
    }

    protected void deleteSelection() {
        if (!this.hasSelection()) {
            return;
        }
        this.commitTextRemoval(this.selectionStart(), this.selectionEnd(), true);
    }

    protected void copySelection() {
        LinePosition visualSelectionEnd;
        Pair<LinePosition, LinePosition> pair = this.getSelection();
        LinePosition visualSelectionStart = pair.component1();
        if (Intrinsics.areEqual(visualSelectionStart, visualSelectionEnd = pair.component2())) {
            return;
        }
        UDesktop.setClipboardString(this.getTextBetween(visualSelectionStart, visualSelectionEnd));
    }

    @Nullable
    protected Character charBefore(@NotNull LinePosition pos) {
        LinePosition linePosition;
        Intrinsics.checkNotNullParameter(pos, "pos");
        LinePosition it = linePosition = pos.toTextualPos();
        boolean bl = false;
        return it.isAtAbsoluteStart() ? null : (it.isAtLineStart() ? Character.valueOf('\n') : Character.valueOf(this.textualLines.get(it.getLine()).getText().charAt(it.getColumn() - 1)));
    }

    @Nullable
    protected Character charAfter(@NotNull LinePosition pos) {
        LinePosition linePosition;
        Intrinsics.checkNotNullParameter(pos, "pos");
        LinePosition it = linePosition = pos.toTextualPos();
        boolean bl = false;
        return it.isAtAbsoluteEnd() ? null : (it.isAtLineEnd() ? Character.valueOf('\n') : Character.valueOf(this.textualLines.get(it.getLine()).getText().charAt(it.getColumn())));
    }

    protected boolean isBreakingCharacter(char ch) {
        return !Character.isLetterOrDigit(ch) && ch != '_';
    }

    @NotNull
    protected LinePosition getNearestWordBoundary(@NotNull LinePosition pos, @NotNull Direction direction) {
        char c;
        char p0;
        Character c2;
        KFunction nextChar2;
        KProperty0 atEndOfDirection2;
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        KProperty0 kProperty0 = atEndOfDirection2 = direction == Direction.Left ? (KProperty0)new PropertyReference0Impl(pos){

            @Nullable
            public Object get() {
                return ((LinePosition)this.receiver).isAtAbsoluteStart();
            }
        } : (KProperty0)new PropertyReference0Impl(pos){

            @Nullable
            public Object get() {
                return ((LinePosition)this.receiver).isAtAbsoluteEnd();
            }
        };
        if (((Boolean)atEndOfDirection2.invoke()).booleanValue()) {
            return pos;
        }
        LinePosition textualPos = pos.toTextualPos();
        int columnOffset = direction == Direction.Left ? -1 : 1;
        KFunction kFunction = nextChar2 = direction == Direction.Left ? (KFunction)((Object)new Function1<LinePosition, Character>((Object)this){

            @Nullable
            public final Character invoke(@NotNull LinePosition p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((AbstractTextInput)this.receiver).charBefore(p0);
            }
        }) : (KFunction)((Object)new Function1<LinePosition, Character>((Object)this){

            @Nullable
            public final Character invoke(@NotNull LinePosition p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((AbstractTextInput)this.receiver).charAfter(p0);
            }
        });
        if (direction == Direction.Left && textualPos.isAtLineStart()) {
            TextualLine previousLine = this.textualLines.get(textualPos.getLine() - 1);
            return new LinePosition(textualPos.getLine() - 1, previousLine.getLength(), false);
        }
        if (direction == Direction.Right && textualPos.isAtLineEnd()) {
            return new LinePosition(textualPos.getLine() + 1, 0, false);
        }
        Character ch = (Character)((Function1)((Object)nextChar2)).invoke(textualPos);
        while (!((Boolean)atEndOfDirection2.invoke()).booleanValue()) {
            boolean bl;
            if (ch != null) {
                p0 = c2.charValue();
                boolean bl2 = false;
                bl = this.isBreakingCharacter(p0);
            } else {
                bl = false;
            }
            if (!bl) break;
            textualPos = textualPos.offsetColumn(columnOffset);
            Character c3 = ch = (Character)((Function1)((Object)nextChar2)).invoke(textualPos);
            c = '\n';
            if (c3 == null || c3.charValue() != c) continue;
            return textualPos;
        }
        while (!((Boolean)atEndOfDirection2.invoke()).booleanValue()) {
            boolean bl;
            if (ch != null) {
                p0 = c2.charValue();
                boolean bl3 = false;
                bl = !this.isBreakingCharacter(p0);
            } else {
                bl = false;
            }
            if (!bl) break;
            textualPos = textualPos.offsetColumn(columnOffset);
            Character c4 = ch = (Character)((Function1)((Object)nextChar2)).invoke(textualPos);
            c = '\n';
            if (c4 == null || c4.charValue() != c) continue;
            return textualPos;
        }
        LinePosition visualPos = textualPos.toVisualPos();
        if (direction == Direction.Left && visualPos.isAtLineEnd() && !visualPos.isInLastLine()) {
            textualPos = new LinePosition(visualPos.getLine() + 1, 0, true);
        } else if (direction == Direction.Right && visualPos.isAtLineStart() && !visualPos.isInFirstLine()) {
            textualPos = new LinePosition(visualPos.getLine() - 1, this.visualLines.get(visualPos.getLine() - 1).getText().length(), true);
        }
        return textualPos;
    }

    protected void animateCursor() {
        AnimatingConstraints anim$iv;
        UIComponent uIComponent;
        if (!this.active) {
            return;
        }
        UIComponent $this$animate$iv = this.cursorComponent;
        boolean $i$f$animate = false;
        UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
        boolean bl = false;
        AnimatingConstraints $this$animateCursor_u24lambda_u2413 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
        boolean bl2 = false;
        AnimatingConstraints.setColorAnimation$default($this$animateCursor_u24lambda_u2413, Animations.OUT_CIRCULAR, 0.5f, UtilitiesKt.toConstraint(this.cursorColor), 0.0f, 8, null);
        $this$animateCursor_u24lambda_u2413.onComplete(new Function0<Unit>(this){
            final /* synthetic */ AbstractTextInput this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                AnimatingConstraints anim$iv;
                void $this$animate$iv;
                void var4_4;
                if (!this.this$0.getActive()) {
                    return;
                }
                UIComponent uIComponent = this.this$0.getCursorComponent();
                AbstractTextInput abstractTextInput = this.this$0;
                boolean $i$f$animate = false;
                void $this$animate_u24lambda_u240$iv = var4_4 = $this$animate$iv;
                boolean bl = false;
                AnimatingConstraints $this$invoke_u24lambda_u240 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
                boolean bl2 = false;
                AnimatingConstraints.setColorAnimation$default($this$invoke_u24lambda_u240, Animations.IN_CIRCULAR, 0.5f, UtilitiesKt.toConstraint(new Color(255, 255, 255, 0)), 0.0f, 8, null);
                $this$invoke_u24lambda_u240.onComplete(new Function0<Unit>(abstractTextInput){
                    final /* synthetic */ AbstractTextInput this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        if (this.this$0.getActive()) {
                            this.this$0.animateCursor();
                        }
                    }
                });
                $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
            }
        });
        $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
    }

    protected boolean hasText() {
        return this.textualLines.size() > 1 || ((CharSequence)this.textualLines.get(0).getText()).length() > 0;
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawUnselectedText(matrixStack, text, left, row)", imports={}))
    protected void drawUnselectedText(@NotNull String text, float left2, int row) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.drawUnselectedText(UMatrixStack.Compat.INSTANCE.get(), text, left2, row);
    }

    protected final void drawUnselectedTextCompat(@NotNull UMatrixStack matrixStack, @NotNull String text, float left2, int row) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(text, "text");
        UMatrixStack.Compat.INSTANCE.runLegacyMethod(matrixStack, (Function0)new Function0<Unit>(this, text, left2, row){
            final /* synthetic */ AbstractTextInput this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ float $left;
            final /* synthetic */ int $row;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                this.$left = $left;
                this.$row = $row;
                super(0);
            }

            public final void invoke() {
                this.this$0.drawUnselectedText(this.$text, this.$left, this.$row);
            }
        });
    }

    protected void drawUnselectedText(@NotNull UMatrixStack matrixStack, @NotNull String text, float left2, int row) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(text, "text");
        FontProvider.drawString$default(this.getFontProvider(), matrixStack, text, this.getColor(), left2 - this.horizontalScrollingOffset, this.getTop() + (this.lineHeight * (float)row + 1.0f) * this.getTextScale() + this.verticalScrollingOffset, 10.0f, this.getTextScale(), false, null, 256, null);
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawSelectedText(matrixStack, text, left, right, row)", imports={}))
    protected void drawSelectedText(@NotNull String text, float left2, float right, int row) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.drawSelectedText(UMatrixStack.Compat.INSTANCE.get(), text, left2, right, row);
    }

    protected final void drawSelectedTextCompat(@NotNull UMatrixStack matrixStack, @NotNull String text, float left2, float right, int row) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(text, "text");
        UMatrixStack.Compat.INSTANCE.runLegacyMethod(matrixStack, (Function0)new Function0<Unit>(this, text, left2, right, row){
            final /* synthetic */ AbstractTextInput this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ float $left;
            final /* synthetic */ float $right;
            final /* synthetic */ int $row;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                this.$left = $left;
                this.$right = $right;
                this.$row = $row;
                super(0);
            }

            public final void invoke() {
                this.this$0.drawSelectedText(this.$text, this.$left, this.$right, this.$row);
            }
        });
    }

    protected void drawSelectedText(@NotNull UMatrixStack matrixStack, @NotNull String text, float left2, float right, int row) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(text, "text");
        UIBlock.Companion.drawBlock(matrixStack, this.active ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor, (double)left2 - (double)this.horizontalScrollingOffset, (double)this.getTop() + (double)(this.lineHeight * (float)row * this.getTextScale()) + (double)this.verticalScrollingOffset, (double)right - (double)this.horizontalScrollingOffset, (double)this.getTop() + (double)(this.lineHeight * ((float)(row + 1) * this.getTextScale())) + (double)this.verticalScrollingOffset);
        if (((CharSequence)text).length() > 0) {
            FontProvider.drawString$default(this.getFontProvider(), matrixStack, text, this.active ? this.selectionForegroundColor : this.inactiveSelectionForegroundColor, left2 - this.horizontalScrollingOffset, this.getTop() + (this.lineHeight * (float)row + 1.0f) * this.getTextScale() + this.verticalScrollingOffset, 10.0f, this.getTextScale(), false, null, 256, null);
        }
    }

    @Override
    public void animationFrame() {
        super.animationFrame();
        float diff = (this.targetVerticalScrollingOffset - this.verticalScrollingOffset) * 0.1f;
        if (Math.abs(diff) < 0.25f) {
            this.verticalScrollingOffset = this.targetVerticalScrollingOffset;
        }
        this.verticalScrollingOffset += diff;
        this.recalculateDimensions();
        if (this.cursorNeedsRefocus) {
            this.scrollIntoView(this.cursor);
            this.cursorNeedsRefocus = false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$AddTextOperation;", "Lgg/essential/elementa/components/input/AbstractTextInput$TextOperation;", "Lgg/essential/elementa/components/input/AbstractTextInput;", "newText", "", "startPos", "Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;", "(Lgg/essential/elementa/components/input/AbstractTextInput;Ljava/lang/String;Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;)V", "redo", "", "undo", "Elementa"})
    protected final class AddTextOperation
    extends TextOperation {
        @NotNull
        private final String newText;
        @NotNull
        private final LinePosition startPos;

        public AddTextOperation(@NotNull String newText, LinePosition startPos) {
            Intrinsics.checkNotNullParameter(newText, "newText");
            Intrinsics.checkNotNullParameter(startPos, "startPos");
            this.newText = newText;
            this.startPos = startPos;
        }

        @Override
        public void redo() {
            AbstractTextInput.this.addText(this.newText, this.startPos);
        }

        @Override
        public void undo() {
            AbstractTextInput.this.removeText(this.startPos, this.startPos.offsetColumn(this.newText.length()));
            AbstractTextInput.this.setCursorPosition(this.startPos.toVisualPos());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$Companion;", "", "()V", "isAllowedCharacter", "", "chr", "", "Elementa"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isAllowedCharacter(char chr) {
            return chr != '\u00a7' && Intrinsics.compare(chr, 32) >= 0 && chr != '\u007f';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$Direction;", "", "(Ljava/lang/String;I)V", "Left", "Right", "Elementa"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction Left = new Direction();
        public static final /* enum */ Direction Right = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.Left, Direction.Right};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0094\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$Line;", "", "text", "", "(Lgg/essential/elementa/components/input/AbstractTextInput;Ljava/lang/String;)V", "length", "", "getLength", "()I", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "Elementa"})
    protected class Line {
        @NotNull
        private String text;

        public Line(String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.text = string;
        }

        public final int getLength() {
            return this.text.length();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0016\u001a\u00020\u00042\n\u0010\u0017\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002J\u0018\u0010\u0018\u001a\u00060\u0000R\u00020\u00022\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00060\u0000R\u00020\u00022\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0002J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\u0012\u0010\u001e\u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0004J!\u0010 \u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00042\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0082\u0010J!\u0010!\u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00042\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0082\u0010J\u0018\u0010\"\u001a\u00060\u0000R\u00020\u00022\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0002J\u0018\u0010#\u001a\u00060\u0000R\u00020\u00022\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0002J\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%J\b\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u00060\u0000R\u00020\u0002J\n\u0010*\u001a\u00060\u0000R\u00020\u0002J\u0012\u0010+\u001a\u00060\u0000R\u00020\u00022\u0006\u0010,\u001a\u00020\u0004R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;", "", "Lgg/essential/elementa/components/input/AbstractTextInput;", "line", "", "column", "isVisual", "", "(Lgg/essential/elementa/components/input/AbstractTextInput;IIZ)V", "getColumn", "()I", "isAtAbsoluteEnd", "()Z", "isAtAbsoluteStart", "isAtLineEnd", "isAtLineStart", "isInFirstLine", "isInLastLine", "getLine", "lines", "", "Lgg/essential/elementa/components/input/AbstractTextInput$Line;", "compareTo", "other", "complexOffsetColumnNegative", "pos", "complexOffsetColumnPositive", "equals", "", "hashCode", "offsetColumn", "amount", "offsetColumnNegative", "offsetColumnPositive", "simpleOffsetColumnNegative", "simpleOffsetColumnPositive", "toScreenPos", "Lkotlin/Pair;", "", "toString", "", "toTextualPos", "toVisualPos", "withColumn", "newColumn", "Elementa"})
    protected final class LinePosition
    implements Comparable<LinePosition> {
        private final int line;
        private final int column;
        private final boolean isVisual;
        @NotNull
        private final List<Line> lines;

        public LinePosition(int line, int column, boolean isVisual) {
            this.line = line;
            this.column = column;
            this.isVisual = isVisual;
            this.lines = this.isVisual ? AbstractTextInput.this.getVisualLines() : AbstractTextInput.this.getTextualLines();
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        public final boolean isVisual() {
            return this.isVisual;
        }

        public final boolean isAtLineStart() {
            return this.column == 0;
        }

        public final boolean isAtLineEnd() {
            return this.column == this.lines.get(this.line).getLength();
        }

        public final boolean isInFirstLine() {
            return this.line == 0;
        }

        public final boolean isInLastLine() {
            return this.line == CollectionsKt.getLastIndex(this.lines);
        }

        public final boolean isAtAbsoluteStart() {
            return this.isInFirstLine() && this.isAtLineStart();
        }

        public final boolean isAtAbsoluteEnd() {
            return this.isInLastLine() && this.isAtLineEnd();
        }

        @NotNull
        public final LinePosition offsetColumn(int amount) {
            return amount > 0 ? this.offsetColumnPositive(amount, this) : (amount < 0 ? this.offsetColumnNegative(-amount, this) : this);
        }

        private final LinePosition offsetColumnNegative(int amount, LinePosition pos) {
            while (amount != 0 && !pos.isAtAbsoluteStart()) {
                LinePosition linePosition = this_;
                int n = amount - 1;
                LinePosition linePosition2 = this_.complexOffsetColumnNegative(pos);
                LinePosition this_ = linePosition;
                amount = n;
                pos = linePosition2;
            }
            return pos;
        }

        private final LinePosition complexOffsetColumnNegative(LinePosition pos) {
            if (!pos.isVisual) {
                return this.simpleOffsetColumnNegative(pos);
            }
            if (!pos.isAtLineStart()) {
                return this.simpleOffsetColumnNegative(pos);
            }
            VisualLine currentLine = AbstractTextInput.this.getVisualLines().get(pos.line);
            VisualLine previousLine = AbstractTextInput.this.getVisualLines().get(pos.line - 1);
            if (currentLine.getTextIndex() != previousLine.getTextIndex()) {
                return this.simpleOffsetColumnNegative(pos);
            }
            if (StringsKt.last(previousLine.getText()) != ' ') {
                return this.simpleOffsetColumnNegative(pos);
            }
            return new LinePosition(pos.line - 1, previousLine.getLength() - 1, true);
        }

        private final LinePosition simpleOffsetColumnNegative(LinePosition pos) {
            return pos.column == 0 ? new LinePosition(pos.line - 1, pos.lines.get(pos.line - 1).getLength(), pos.isVisual) : pos.withColumn(pos.column - 1);
        }

        private final LinePosition offsetColumnPositive(int amount, LinePosition pos) {
            while (amount != 0 && !pos.isAtAbsoluteEnd()) {
                LinePosition linePosition = this_;
                int n = amount - 1;
                LinePosition linePosition2 = this_.complexOffsetColumnPositive(pos);
                LinePosition this_ = linePosition;
                amount = n;
                pos = linePosition2;
            }
            return pos;
        }

        private final LinePosition complexOffsetColumnPositive(LinePosition pos) {
            if (!pos.isVisual) {
                return this.simpleOffsetColumnPositive(pos);
            }
            VisualLine currentLine = AbstractTextInput.this.getVisualLines().get(pos.line);
            if (pos.column < currentLine.getLength() - 1) {
                return this.simpleOffsetColumnPositive(pos);
            }
            if (pos.line == CollectionsKt.getLastIndex(AbstractTextInput.this.getVisualLines())) {
                return new LinePosition(pos.line, currentLine.getLength(), true);
            }
            if (pos.column == currentLine.getLength() - 1 && StringsKt.last(currentLine.getText()) != ' ') {
                return this.simpleOffsetColumnPositive(pos);
            }
            VisualLine nextLine = AbstractTextInput.this.getVisualLines().get(pos.line + 1);
            if (currentLine.getTextIndex() == nextLine.getTextIndex()) {
                return new LinePosition(pos.line + 1, 0, true);
            }
            return this.simpleOffsetColumnPositive(pos);
        }

        private final LinePosition simpleOffsetColumnPositive(LinePosition pos) {
            return pos.column >= pos.lines.get(pos.line).getLength() ? (pos.line == CollectionsKt.getLastIndex(pos.lines) ? new LinePosition(CollectionsKt.getLastIndex(pos.lines), CollectionsKt.last(pos.lines).getLength(), pos.isVisual) : new LinePosition(pos.line + 1, 0, pos.isVisual)) : pos.withColumn(pos.column + 1);
        }

        @NotNull
        public final LinePosition withColumn(int newColumn) {
            return new LinePosition(this.line, newColumn, this.isVisual);
        }

        @NotNull
        public final LinePosition toTextualPos() {
            if (!this.isVisual) {
                return this;
            }
            VisualLine visualLine = AbstractTextInput.this.getVisualLines().get(this.line);
            TextualLine textualLine = AbstractTextInput.this.getTextualLines().get(visualLine.getTextIndex());
            int totalVisualLength = 0;
            int n = this.line;
            for (int i2 = textualLine.getVisualIndices().getFirst(); i2 < n; ++i2) {
                totalVisualLength += AbstractTextInput.this.getVisualLines().get(i2).getLength();
            }
            return new LinePosition(visualLine.getTextIndex(), totalVisualLength + this.column, false);
        }

        @NotNull
        public final LinePosition toVisualPos() {
            int n;
            if (this.isVisual) {
                return this;
            }
            TextualLine textualLine = AbstractTextInput.this.getTextualLines().get(this.line);
            int lengthRemaining = this.column;
            Object object = textualLine.getVisualIndices();
            int visualLineIndex = ((IntProgression)object).getFirst();
            if (visualLineIndex <= (n = ((IntProgression)object).getLast())) {
                while (true) {
                    VisualLine visualLine;
                    if ((visualLine = AbstractTextInput.this.getVisualLines().get(visualLineIndex)).getLength() >= lengthRemaining) {
                        return new LinePosition(visualLineIndex, lengthRemaining, true);
                    }
                    lengthRemaining -= visualLine.getLength();
                    if (visualLineIndex == n) break;
                    ++visualLineIndex;
                }
            }
            object = "toTextualPos: Unexpected end of function";
            System.out.println(object);
            return new LinePosition(0, 0, true);
        }

        @NotNull
        public final Pair<Float, Float> toScreenPos() {
            LinePosition visualPos = this.toVisualPos();
            String string = AbstractTextInput.this.getVisualLines().get(visualPos.line).getText();
            int n = 0;
            int n2 = visualPos.column;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            float x = UtilitiesKt.width$default(string3, AbstractTextInput.this.getTextScale(), null, 2, null) - AbstractTextInput.this.getHorizontalScrollingOffset();
            float y = AbstractTextInput.this.getLineHeight() * (float)visualPos.line * AbstractTextInput.this.getTextScale() + AbstractTextInput.this.getVerticalScrollingOffset();
            return TuplesKt.to(Float.valueOf(x), Float.valueOf(y));
        }

        @Override
        public int compareTo(@NotNull LinePosition other) {
            Intrinsics.checkNotNullParameter(other, "other");
            LinePosition thisVisual = this.toVisualPos();
            LinePosition otherVisual = other.toVisualPos();
            return thisVisual.line < otherVisual.line ? -1 : (thisVisual.line > otherVisual.line ? 1 : (thisVisual.column < otherVisual.column ? -1 : (thisVisual.column > otherVisual.column ? 1 : 0)));
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof LinePosition && this.line == ((LinePosition)other).line && this.column == ((LinePosition)other).column && this.isVisual == ((LinePosition)other).isVisual;
        }

        public int hashCode() {
            int result = this.line;
            result = 31 * result + this.column;
            result = 31 * result + Boolean.hashCode(this.isVisual);
            return result;
        }

        @NotNull
        public String toString() {
            return "LinePosition(line=" + this.line + ", column=" + this.column + ", isVisual=" + this.isVisual + ')';
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0002\u0012\n\u0010\u0005\u001a\u00060\u0004R\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0012\u0010\u0005\u001a\u00060\u0004R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$RemoveTextOperation;", "Lgg/essential/elementa/components/input/AbstractTextInput$TextOperation;", "Lgg/essential/elementa/components/input/AbstractTextInput;", "startPos", "Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;", "endPos", "selectAfterUndo", "", "(Lgg/essential/elementa/components/input/AbstractTextInput;Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;Lgg/essential/elementa/components/input/AbstractTextInput$LinePosition;Z)V", "text", "", "getText", "()Ljava/lang/String;", "redo", "", "undo", "Elementa"})
    protected final class RemoveTextOperation
    extends TextOperation {
        @NotNull
        private final LinePosition startPos;
        @NotNull
        private final LinePosition endPos;
        private final boolean selectAfterUndo;
        @NotNull
        private final String text;

        public RemoveTextOperation(@NotNull LinePosition startPos, LinePosition endPos, boolean selectAfterUndo) {
            Intrinsics.checkNotNullParameter(startPos, "startPos");
            Intrinsics.checkNotNullParameter(endPos, "endPos");
            this.startPos = startPos;
            this.endPos = endPos;
            this.selectAfterUndo = selectAfterUndo;
            this.text = AbstractTextInput.this.getTextBetween(this.startPos, this.endPos);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Override
        public void redo() {
            LinePosition textualStartPos = this.startPos.toTextualPos();
            AbstractTextInput.this.removeText(textualStartPos, this.endPos);
            AbstractTextInput.this.setCursorPosition(textualStartPos);
        }

        @Override
        public void undo() {
            AbstractTextInput.this.addText(this.text, this.startPos);
            if (this.selectAfterUndo) {
                AbstractTextInput.this.setCursor(this.startPos);
                AbstractTextInput.this.setOtherSelectionEnd(this.endPos);
                AbstractTextInput.this.setCursorNeedsRefocus(true);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0002\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$ReplaceTextOperation;", "Lgg/essential/elementa/components/input/AbstractTextInput$TextOperation;", "Lgg/essential/elementa/components/input/AbstractTextInput;", "addTextOperation", "Lgg/essential/elementa/components/input/AbstractTextInput$AddTextOperation;", "removeTextOperation", "Lgg/essential/elementa/components/input/AbstractTextInput$RemoveTextOperation;", "(Lgg/essential/elementa/components/input/AbstractTextInput;Lgg/essential/elementa/components/input/AbstractTextInput$AddTextOperation;Lgg/essential/elementa/components/input/AbstractTextInput$RemoveTextOperation;)V", "redo", "", "undo", "Elementa"})
    protected final class ReplaceTextOperation
    extends TextOperation {
        @NotNull
        private final AddTextOperation addTextOperation;
        @NotNull
        private final RemoveTextOperation removeTextOperation;

        public ReplaceTextOperation(@NotNull AddTextOperation addTextOperation, RemoveTextOperation removeTextOperation) {
            Intrinsics.checkNotNullParameter(addTextOperation, "addTextOperation");
            Intrinsics.checkNotNullParameter(removeTextOperation, "removeTextOperation");
            this.addTextOperation = addTextOperation;
            this.removeTextOperation = removeTextOperation;
        }

        @Override
        public void redo() {
            this.removeTextOperation.redo();
            this.addTextOperation.redo();
        }

        @Override
        public void undo() {
            this.addTextOperation.undo();
            this.removeTextOperation.undo();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$SelectionMode;", "", "(Ljava/lang/String;I)V", "None", "Character", "Word", "Line", "Elementa"})
    public static final class SelectionMode
    extends Enum<SelectionMode> {
        public static final /* enum */ SelectionMode None = new SelectionMode();
        public static final /* enum */ SelectionMode Character = new SelectionMode();
        public static final /* enum */ SelectionMode Word = new SelectionMode();
        public static final /* enum */ SelectionMode Line = new SelectionMode();
        private static final /* synthetic */ SelectionMode[] $VALUES;

        public static SelectionMode[] values() {
            return (SelectionMode[])$VALUES.clone();
        }

        public static SelectionMode valueOf(String value) {
            return Enum.valueOf(SelectionMode.class, value);
        }

        static {
            $VALUES = selectionModeArray = new SelectionMode[]{SelectionMode.None, SelectionMode.Character, SelectionMode.Word, SelectionMode.Line};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0004H&\u00a8\u0006\u0006"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$TextOperation;", "", "(Lgg/essential/elementa/components/input/AbstractTextInput;)V", "redo", "", "undo", "Elementa"})
    protected abstract class TextOperation {
        public abstract void redo();

        public abstract void undo();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$TextualLine;", "Lgg/essential/elementa/components/input/AbstractTextInput$Line;", "Lgg/essential/elementa/components/input/AbstractTextInput;", "text", "", "visualIndices", "Lkotlin/ranges/IntRange;", "(Lgg/essential/elementa/components/input/AbstractTextInput;Ljava/lang/String;Lkotlin/ranges/IntRange;)V", "getVisualIndices", "()Lkotlin/ranges/IntRange;", "setVisualIndices", "(Lkotlin/ranges/IntRange;)V", "addTextAt", "", "newText", "column", "", "toString", "Elementa"})
    protected final class TextualLine
    extends Line {
        @NotNull
        private IntRange visualIndices;
        final /* synthetic */ AbstractTextInput this$0;

        public TextualLine(@NotNull AbstractTextInput this$0, @NotNull String text, IntRange visualIndices) {
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(visualIndices, "visualIndices");
            this.this$0 = this$0;
            super(text);
            this.visualIndices = visualIndices;
        }

        public /* synthetic */ TextualLine(AbstractTextInput abstractTextInput, String string, IntRange intRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                intRange = new IntRange(0, 0);
            }
            this(abstractTextInput, string, intRange);
        }

        @NotNull
        public final IntRange getVisualIndices() {
            return this.visualIndices;
        }

        public final void setVisualIndices(@NotNull IntRange intRange) {
            Intrinsics.checkNotNullParameter(intRange, "<set-?>");
            this.visualIndices = intRange;
        }

        public final void addTextAt(@NotNull String newText, int column) {
            Intrinsics.checkNotNullParameter(newText, "newText");
            if (column >= this.getText().length()) {
                this.setText(this.getText() + newText);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string = this.getText();
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, column);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder2 = stringBuilder.append(string3).append(newText);
                String string4 = string = this.getText();
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(column);
                Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).substring(startIndex)");
                this.setText(stringBuilder2.append(string5).toString());
            }
        }

        @NotNull
        public String toString() {
            return "TextualLine(text=" + this.getText() + ", visualIndices=" + this.visualIndices + ')';
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0004H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lgg/essential/elementa/components/input/AbstractTextInput$VisualLine;", "Lgg/essential/elementa/components/input/AbstractTextInput$Line;", "Lgg/essential/elementa/components/input/AbstractTextInput;", "text", "", "textIndex", "", "(Lgg/essential/elementa/components/input/AbstractTextInput;Ljava/lang/String;I)V", "getTextIndex", "()I", "toString", "Elementa"})
    protected final class VisualLine
    extends Line {
        private final int textIndex;

        public VisualLine(String text, int textIndex) {
            Intrinsics.checkNotNullParameter(text, "text");
            super(text);
            this.textIndex = textIndex;
        }

        public final int getTextIndex() {
            return this.textIndex;
        }

        @NotNull
        public String toString() {
            return "VisualLine(text=" + this.getText() + ", textIndex=" + this.textIndex + ')';
        }
    }
}

